## Functions
# Unnötige Spalten löschen
exCol <- function(x) {
  x <- x[, !names(x) %in% c('D','SH','MV','RP','SL','HE','TH','ST','BW','NI','HH','NW','BB','SN','BAY','BNG','WA','FFH','FFHCODE','RL_TAXNR','NE','NB')]
  return(x)
}

# Ermittle Rangstufe aus Taxnamenkürzeln
rang.fun <- function(data, variable = 'RANG', grepfrom = 'TAXNAME', ...) {
  if(!'RANG' %in% names(data)) data$RANG <- NA
  ind <- data[,variable] == '' | is.na(data[,variable])
  #   data[ind,grepfrom] <- sub(' ssp. ', ' subsp. ', data[ind,grepfrom])
  #   data[ind,grepfrom] <- sub(' f. ', ' fo. ', data[ind,grepfrom])
  data[ind, grepfrom] <- taxname.abbr(data[ind,grepfrom])
  data[ind, variable][grep(' fo.', data[ind,grepfrom], fixed=TRUE)] <- 'FOR'
  data[ind, variable][grep(' var.', data[ind,grepfrom], fixed=TRUE)] <- 'VAR'
  data[ind, variable][grep(' subsp.', data[ind,grepfrom], fixed=TRUE)] <- 'SSP'
  data[ind, variable][grep(' agg.', data[ind,grepfrom], fixed=TRUE)] <- 'AGG'
  data[ind, variable][grep(' spec.', data[ind,grepfrom], fixed=TRUE)] <- 'GAT'
  data[ind, variable][grep(' species', data[ind,grepfrom], fixed=TRUE)] <- 'GAT'
  data[, variable][data[,variable]==''|is.na(data[,variable])] <- 'SPE'
  data[ind,variable][!grepl(".+\\s+", data[ind,grepfrom])] <- 'GAT'
  return(data)
}


# Erstelle Hierarchie aus Rangstufen
agg.fun <- function(data, ...) {
  # c('ZUS','FOR','VAR','SSP','SPE','AGG', 'SGE','SER','SSE','SEC','AG1','GAT','AG2','FAM','ORD','UKL','KLA','UAB','ABT','AG3','ROOT')
  if(any(data$RANG=='' | is.na(data$RANG))) stop('Rangstufen nicht vollständig!')
  if(!'AGGNAME' %in% names(data)) data$AGGNAME <- NA
  if(!'AGGNR' %in% names(data)) data$AGGNR <- NA
  data$AGGNAME[data$AGGNAME == ''] <- NA

  # Ergänze AGGNR wenn AGGName vorhanden ist, auch AGGNR überschreiben
  data$AGGNR[!is.na(data$AGGNAME)] <- data$NAMNR[match(data$AGGNAME[!is.na(data$AGGNAME)], data$TAXNAME)]
  # Ergänze AGGName wenn AGGNR vorhanden ist
  data$AGGNAME[!is.na(data$AGGNR) & is.na(data$AGGNAME)] <- data$TAXNAME[match(data$AGGNR[!is.na(data$AGGNR) & is.na(data$AGGNAME)], data$NAMNR) ]
 
  # Ergänze Gattungs parent für Ränge zw. Art- und Gattungsniveau
  missaggnames <- data$RANG %in% c('SPE', 'AGG', 'SGE','SER','SSE','SEC','AG1') & data$GUELT == 1 & is.na(data$AGGNAME)
  if(sum(missaggnames) > 0) {
    data$AGGNAME[missaggnames] <- unlist(sapply(data$TAXNAME[missaggnames], vegdata:::first.word))
    data$AGGNR[!is.na(data$AGGNAME) & is.na(data$AGGNR)] <- data$NAMNR[match(data$AGGNAME[!is.na(data$AGGNAME) & is.na(data$AGGNR)], data$TAXNAME)]
  }
  missaggnr <- data$RANG %in% c('SPE', 'AGG', 'SGE','SER','SSE','SEC','AG1')  & data$GUELT == 1 & is.na(data$AGGNR)
  if(sum(missaggnr) > 0) data$AGGNR[missaggnr] <- data$NAMNR[match(data$AGGNAME[missaggnr], data$TAXNAME)][missaggnr]

  # Ergänze Art parents für Ränge unterhalb Artniveau
  for(r in c('ZUS', 'FOR','VAR', 'SSP')) {
    patt <- switch(r, ZUS = ' \\* ', FOR = ' fo\\.',     VAR = ' var\\.',   SSP = ' subsp\\.')
    ind <- grep(patt, data$TAXNAME)
    ind <- ind[is.na(data$AGGNR[ind]) & data$GUELT[ind] == 1]
    sp <- sapply(strsplit(data$TAXNAME, patt), function(x) x[1])
    if(length(ind)>0) data[ind,'AGGNAME'] <- sp[ind]
    if(length(ind)>0) data[ind,'AGGNR'] <- data$NAMNR[match(sp[ind], data$TAXNAME)]
  }

  # #   data$AGGNR[data$RANG == 'AGG'  & data$GUELT == 1 & is.na(data$AGGNR)] <- data$NAMNR[match(data$AGGNAME[data$RANG == 'AGG'  & data$GUELT == 1 & is.na(data$AGGNR)], data$TAXNAME)]
#   ind <- is.na(data$AGGNAME) & data$GUELT == 1 & !is.na(data$AGGNR)
#   data$AGGNAME[ind] <- data$TAXNAME[match(data[ind, 'AGGNR'], data$NAMNR)]
  
  # Ergänze AGGNR wenn AGGName vorhanden ist
  data$AGGNR[!is.na(data$AGGNAME) & is.na(data$AGGNR)] <- data$NAMNR[match(data$AGGNAME[!is.na(data$AGGNAME) & is.na(data$AGGNR)], data$TAXNAME)]
  # Ergänze AGGName wenn AGGNR vorhanden ist
  data$AGGNAME[!is.na(data$AGGNR) & is.na(data$AGGNAME)] <- data$TAXNAME[match(data$AGGNR[!is.na(data$AGGNR) & is.na(data$AGGNAME)], data$NAMNR) ]
  
  noagg <- sum(is.na(data$AGGNAME) & data$GUELT == 1 & !is.na(data$AGGNR))
  if(noagg > 0) {
    cat(nrow(data[is.na(data$AGGNAME) & data$GUELT == 1 & !is.na(data$AGGNR),] ), 'AggNames not complete, please check\n')
    if(noagg < 15) print(data[is.na(data$AGGNAME) & data$GUELT == 1 & !is.na(data$AGGNR), c('TAXNAME', 'NAMNR', 'GUELT', 'AGGNR') ]) 
  }
  return(data)
}


### End of functions section
# 
# data <- data3[grep('Achillea', data3$TAXNAME) ,c(1:5,10,13,51)]
# data <- data[data$GUELT==1,]
# 
# data <- data3[is.na(data3$AGGNAME) & data3$GUELT==1,]
# data <- data7[is.na(data7$AGGNAME) & data7$GUELT==1,]
