################################################
## Check taxonomic reference list
################################################

check <- function(data7, verbose=FALSE) {
  refl <<- data7
  require(vegdata)
  cat('###############################################\n')  
  cat('# Integrity check for taxonomic reference list:\n')
  cat('###############################################\n')

  tmp <- refl[(refl$TAXNAME==0 | is.na(refl$TAXNAME) ), 1:15]
  if(nrow(tmp)>0) {
        cat('! Taxa ohne TAXNAME:\n')
	if(verbose) print(tmp) # Nur "Grünliches etwas" mit NAMNR == 0
    } else cat('ok Alle Angaben mit TAXNAME\n')
  if(any(table(refl$TAXNAME)>1)) {
    df <- as.data.frame(table(refl$TAXNAME))
    df$Var1[df$Freq > 1]
    stop('! Doppelte TAXNAME vorhanden.\n') } else cat('ok Keine doppelten TAXNAMEs vorhanden. \n')
# refl[duplicated(refl$TAXNAME),]
# refl[grep('Rorippa x', refl$TAXNAME),]
  tmp <- refl[(refl$NAMNR==0 | is.na(refl$NAMNR) ) & refl$RANG!='ROOT', 1:15]
  if(nrow(tmp) > 0) {
        cat('! Taxa ohne NAMNR:\n')
	if(verbose) print(tmp) # Nur "Grünliches etwas" mit NAMNR == 0
    } else cat('ok Alle Namen mit NAMNR\n')
  if(any(table(refl$NAMNR)>1)) stop('! Doppelte NAMNR vorhanden\n') else cat('ok Keine doppelten NAMNR vorhanden. \n')

  tmp <- refl[(refl$SIPNR==0 | is.na(refl$SIPNR) ) & refl$RANG!='ROOT', 1:15]
  if(nrow(tmp) > 0) {
      cat('! Taxa ohne SIPNR oder SIPNR = 0:\n')
      if(verbose) print(tmp) # Nur "Grünliches etwas" mit SIPNR == 0
    } else cat('ok Alle Namen mit SIPNR.\n')
#   t <- table(refl$TAXNAME)
#   refl[refl$TAXNAME %in% names(t)[which(t>1)], ]
  if(any(is.na(refl$VALIDNAME))) {
    warning(paste('! Für', sum(is.na(refl$VALIDNAME)), 'Taxa sind keine Validnames vergeben.\n'))
    if(verbose) print(refl[is.na(refl$VALIDNAME),])
    stop()
  }
# tax(refl$NAMNR[which(is.na(refl$VALIDNAME))], d=T)
  if(any(!refl$'VALIDNAME' %in% refl$TAXNAME[refl$GUELT=='1'])) {
    cat('!', sum(!refl$'VALIDNAME' %in% refl$TAXNAME[refl$GUELT == '1']), 'Valid Names nicht in TAXNAME vorhanden:\n')
    validnam <- refl[!refl$'VALIDNAME' %in% refl$TAXNAME[refl$GUELT == '1'],c(1:15,50,51)]
    if(verbose) print(validnam) } else cat("ok ValidName's ok.\n")

  if(any(!refl$'SIPNR' %in% refl$NAMNR[refl$GUELT=='1'])) { 
    cat('!', sum(!refl$'SIPNR' %in% refl$NAMNR[refl$GUELT=='1']), 'SIPNR nicht in NAMNR gültiger Taxa vorhanden:\n')
    validnr <- refl[!refl$SIPNR %in% refl$NAMNR[refl$GUELT=='1'],]
  if(verbose & nrow(validnr > 0)) print(validnr) } else cat("ok SIPNR's ok.\n")
  
if(any(refl$GUELT == refl$SYNONYM)) { cat('! GUELT und SYNONYM widersprüchlich:\n')
   validquestions <- refl[refl$GUELT == refl$SYNONYM,]
   if(verbose & nrow(validquestions > 0)) print(validquestions) 
   } else cat("ok GUELT and SYNONYM ok.\n")

if(any(refl$GUELT == 1 & refl$TAXNAME != refl$VALIDNAME)) { 
  cat('! gültige Taxa mit unterschiedlichen Taxname und Validname:\n')
  validnamequest <- refl[refl$GUELT == 1 & refl$TAXNAME != refl$VALIDNAME, ]
  if(verbose & nrow(validnamequest > 0)) print(validnamequest) 
}

## Secundum
  tmp <- refl[is.na(refl$SECUNDUM) | refl$SECUNDUM=='', 1:15]
  if(nrow(tmp)>0) {
      cat('! Angaben ohne Secundum\n')
      if(verbose) print(tmp) 
    } else cat('ok Alle Namen mit Quellenangabe.\n')

## Valid
  if(with(refl, any(NAMNR[GUELT==1] != SIPNR[GUELT==1]))) {
    cat('! Nicht alle gültigen Taxa haben identische NAMNR und SIPNR')
    } else cat('ok Für alle gültigen Taxa sind NAMNR und SIPNR identisch.\n')
#   val <- refl[refl$GUELT==1,c(1,2,5,8,14)]
#   tmp <- val[val$NAMNR != val$SIPNR,]
#   if(nrow(tmp)>0) print(tmp) else cat('ok Für alle gültigen Taxa sind NAMNR und SIPNR identisch.\n')
#   head(refl[refl$NAMNR[refl$GUELT==1] != refl$SIPNR[refl$GUELT==1],])
#   tail(refl$NAMNR[refl$GUELT==1] != refl$SIPNR[refl$GUELT==1])

# Alle ungültigen Taxa mit NAMNR != SIPNR
  if(with(refl, any(NAMNR[GUELT!=1] == SIPNR[GUELT!=1]))) { cat('! Ungültige Namen mit identischen NAMNR und SIPNR vorhanden.\n')
      (tmp <- refl[refl$NAMNR == refl$SIPNR & refl$GUELT!='1',])  } else 
    cat('ok Für alle ungültigen Taxa sind NAMNR und SIPNR unterschiedlich.\n')

## Aggregierung
  if(any(refl$AGGNR == refl$NAMNR & refl$NAMNR != 0, na.rm=TRUE)) stop('! Selbtreferentielle Aggregierung gefunden.')
  if(any(is.na(refl$AGGNR) & refl$GUELT==1)) {
    cat('!', sum(is.na(refl$AGGNR) & refl$GUELT==1), 'gültige Namen haben keine AGGNR.\n')
    # tmp <- refl[is.na(refl$AGGNR) & refl$GUELT==1,]
    if(verbose)	print(refl[is.na(refl$AGGNR) & refl$GUELT==1,])
  }
  if(any(is.na(refl$AGGNAME) & refl$GUELT==1)) {
    cat('! Nicht alle gültigen Namen haben AGGNAME.\n')
    if(verbose)	print(refl[is.na(refl$AGGNAME) & refl$GUELT==1,])
  }
  if(any(!is.na(refl$AGGNAME) & refl$GUELT==0)) {
    cat('! Synonyme mit AGGNAME. Synonyme sollten nicht Teil der Hierarchie sein!\n')
    if(verbose)  print(refl[!is.na(refl$AGGNAME) & refl$GUELT==0, c('NAMNR','TAXNAME', 'GUELT', 'RANG', 'AGGNAME', 'EditStatus')])
  }
  if(any(!taxname.abbr(refl$AGGNAME[refl$GUELT=='1' & !is.na(refl$AGGNAME)]) %in% taxname.abbr(refl$TAXNAME)))  cat('Nicht alle Aggregate in gültigen TAXNAME vorhanden.\n') else cat('ok Alle AGGNAME lassen sich zuordnen.\n')
    tmp <- refl$AGGNR[refl$GUELT=='1' & !is.na(refl$AGGNR)] 
    noagg <- tmp[!tmp %in% refl$NAMNR]
  if(length(noagg)>0) {	cat('! Nicht alle AGGNR in gültigen TAXNR vorhanden.\n') 
    if(verbose) print(refl[match(noagg,refl$AGGNR),c(1:15,22)]) } else cat('ok Alle AGGNR lassen sich zuordnen.\n')
    tmp <- refl[is.na(refl$AGGNR) & refl$GUELT=='1',]
  if(nrow(tmp)>0) { 
      cat('! Nicht alle gültigen Taxa haben eine gültige Aggregierungsinformation! \n')
      if(verbose) print(tmp[, c('NAMNR', 'TAXNAME','EditStatus')]) 
    } else cat('ok Alle gültigen Taxa haben eine Aggregierungsinformation.\n\n')

############  Check Lettercodes  ###########
  if(any(is.na(data7$lettercode))) {
    print(data7[which(is.na(data7$lettercode)),])
# which(is.na(data7[data7$SIPNR == data7$NAMNR,]$lettercode))

  }

############  Check Hierarchy  ###########
  if(any(!is.na(refl$AGGNR[refl$SYNONYM]))) { cat('! Synonyme mit Aggregierungsinformation vorhanden! \n')
    if(verbose) print(head(refl$TAXNAME[!is.na(refl$AGG[refl$NAMNR != refl$SIPNR])]))
  }
  accepted <- refl[refl$NAMNR == refl$SIPNR,]
  accepted$AGG_RANG <- accepted$RANG[match(accepted$AGGNR, accepted$NAMNR)]
  taxlevels <- factor(c('ZUS','FOR','VAR','SSP','SPE','AGG', 'SGE','SER','SSE','SEC','AG1','GAT','AG2','FAM','ORD','UKL','KLA','UAB','ABT','AG3','ROOT'), 
              levels= c('ZUS','FOR','VAR','SSP','SPE','AGG', 'SGE','SER','SSE','SEC','AG1','GAT','AG2','FAM','ORD','UKL','KLA','UAB','ABT','AG3','ROOT'), ordered=TRUE)
  for(g in taxlevels) {
    if(!g %in% c('AGG','AG1','ROOT')) {
    tmp <- accepted[accepted$RANG == g & accepted$AGG_RANG == g, c('NAMNR','RANG', 'TAXNAME', 'AGGNAME', 'AGG_RANG')]
    if(nrow(tmp)>0) {
      print(paste('! Elternbeziehungen vorhanden, die auf die gleiche Rangstufe', g, 'verweisen.'))
      if(verbose) print(tmp)
    }}
  }
  accepted$dif <- match(accepted$AGG_RANG, taxlevels) - match(accepted$RANG, taxlevels)
#  accepted$dif[accepted$AGG_RANG == 'AGG'] <- 0; 
#  accepted$dif[accepted$RANG == 'AGG'] <- 0
  if(any(accepted$dif < 0)) {
    cat('! Ggf. Elternbeziehungen zu niedrigeren Rangstufen vorhanden\n')
    if(verbose) print(accepted[accepted$dif < 0, c('NAMNR','TAXNAME', 'RANG', 'AGGNAME', 'AGG_RANG')])
  }
  accepted$RankParent <- accepted$RANG[match(accepted$AGGNR, accepted$NAMNR)]
  tab <- table(accepted$RANG, accepted$RankParent)
  
  sink('germansl1.3.dot')
  cat('digraph {','\n')
  for(r in 1:nrow(tab))
    for(c in 1:ncol(tab))
      if(tab[r,c] > 0) cat(dimnames(tab)[[1]][r], '->', dimnames(tab)[[2]][c], ' [label=', tab[r,c], '];\n')
  cat('}')
  sink()
  
  system('dot -Tpng -o germansl1.3.png germansl1.3.dot')
# 
#write.csv2(accepted[which(accepted$RANG == 'GAT' & accepted$RankParent == 'KLA'), c("NAMNR","SYNONYM","RANG","TAXNAME","GROUP","AGGNR","EditStatus","VALIDNAME","AGGNAME","Family", "RankParent")], file='GAT-KLA.csv')
}

check(data7, verbose=T)
