################################################
## Debug GermanSL Reference list
################################################
# name <- 'GermanSL 1.3'

## create GermanSL:
source('code/GermanSl_sqlite.r')
source('code/check.r')

#########################################
### Turboveg
taxdbf <- with(data7, data.frame(SPECIES_NR=NAMNR, LETTERCODE=data7$lettercode, ABBREVIAT=TAXNAME, AUTHOR=AUTOR, SYNONYM=NAMNR!=SIPNR, VALID_NR=SIPNR, VALID_NAME=as.character(VALIDNAME), NATIVENAME=TRIVIAL1, RANG=RANG, GRUPPE=GROUP, AGG=AGGNR, AGG_NAME=as.character(AGGNAME), NACHWEIS=NACHWEIS, SECUNDUM=SECUNDUM, HYBRID=Hybrid, BEGRUEND=Grund, EDITSTATUS=EditStatus))
taxdbf$ABBREVIAT <- iconv(taxdbf$ABBREVIAT, 'UTF-8', 'CP437', sub='')
taxdbf$NATIVENAME <- iconv(taxdbf$NATIVENAME, 'UTF-8', 'CP437', sub='')
taxdbf$AUTHOR <- iconv(taxdbf$AUTHOR, 'UTF-8', 'CP437', sub='')
write.dbf(taxdbf, file='tax.dbf')
library(RSQLite)
conn <- dbConnect(SQLite(), 'germansl.sqlite')
dbWriteTable(conn, name = 'GermanSL', taxdbf, o=T)
dbWriteTable(conn, name = 'version', data.frame(version='1.3.1', datum=date()), o=T)


species <- taxdbf[, c('SPECIES_NR', 'LETTERCODE', 'ABBREVIAT', 'ABBREVIAT', 'NATIVENAME', 'AUTHOR', 'SYNONYM', 'VALID_NR', 'AGG', 'RANG', 'SECUNDUM', 'EDITSTATUS')]
names(species)[3:4] <- c("SHORTNAME","ABBREVIAT")
species$SHORTNAME <- abbreviate(species$SHORTNAME, minlength=22)
# species$AUTHOR <- ''
write.dbf(species, 'species.dbf')

monotypic(refl = 'GermanSL 1.3', write=TRUE, filename='monotypic-D.csv')

#########################################
## Traits and RL
library(vegdata)
taxdbf <- read.dbf('tax.dbf')
library(RSQLite)
m <- dbDriver("SQLite")
con <- dbConnect(m, dbname = 'tv_refliste.sqlite')
dbListTables(con)
traits <- dbGetQuery(con, "SELECT * FROM Traits2")
paste(shQuote(names(traits)), collapse=",")

# Ecodbase
select.eco <- c('TAXNR','GATT_NAME','FAMILY','Z_OEK_L','OEK_L','Z_OEK_T','OEK_T','Z_OEK_K','OEK_K','Z_OEK_F','OEK_F','WASSERREGI','Z_OEK_R','OEK_R','Z_OEK_N','OEK_N','Z_OEK_S','OEK_S','Z_OEK_TO','OEK_TO','Z_OEK_SU','OEK_SU','Z_OEK_SON','OEK_SON','Z_LF_LEB','LF_LEB','Z_LF_B','LF_B','WUCHS_1','WUCHS_2','WUCHS_3','Z_SZ_V_GR','SZ_VERH_GR','Z_SZ_V_K','SZ_VERH_K','Z_SZ_O','SZ_O','Z_SZ_V','SZ_V','Z_SZ_U','SZ_U','Vorkommen','Gilde','Mahdverträglichkeit','Weideverträglichkeit','Trittverträglichkeit','Futterwert','Futterwert_für_Damwild')
ecodbase <- merge(taxdbf[,c("SPECIES_NR","LETTERCODE","ABBREVIAT","RANG", "GRUPPE")], traits[,select.eco], by.x='SPECIES_NR', by.y='TAXNR')
sum(apply(ecodbase[,select.eco[4:length(select.eco)]], 1, function(x) all(is.na(x) | x == 0 | x == '')))
ecodbase <- ecodbase[!apply(ecodbase[,select.eco[4:length(select.eco)]], 1, function(x) all(is.na(x) | x == 0 | x == '')),]
head(ecodbase)
names(ecodbase) <- make.names(names(ecodbase))
names(ecodbase) <- sub(pattern = 'ä', replacement = 'ae', x = names(ecodbase))
write.dbf(ecodbase, file='ecodbase.dbf')

# Distribution
select.dist <- c('TAXNR','Z_HAEUF_M','HAEUF_M','Z_HAEUF_D','HAEUF_D','Z_HAEUF_AE','HAEUF_AE','Arealformel','BB','BW','BY','HE','MV','NI','NRW','RP','SH','SN','ST','TH','Anz_BL')
dist <- merge(taxdbf[,c("SPECIES_NR","LETTERCODE","ABBREVIAT","RANG", "GRUPPE")], traits[,select.dist], by.x='SPECIES_NR', by.y='TAXNR')
sum(apply(dist[,select.dist[9:length(select.dist)]], 1, function(x) all(is.na(x) | x == 0 | x == '')))
dist <- dist[!apply(dist[,select.dist[4:length(select.dist)]], 1, function(x) all(is.na(x) | x == 0 | x == '')),]
head(dist)
head(dist[!apply(dist[,select.dist[9:length(select.dist)]], 1, function(x) all(is.na(x) | x == 0 | x == '')),])
write.csv2(dist, file='distribution.csv')

# RL Mecklenburg-Vorpommern
rl <- dbGetQuery(con, "SELECT * FROM Flora_2007")
paste(shQuote(names(rl)), collapse=",")
select.rl <- c('Taxname', 'STATUS_D','N','F','T','AR','HEIMAT','HÄUFIGK','GEF2006','GEF1991','RL_BALT','RLD','FFH_Anh','BARTSCH','TAX_Ind','TAX_Bew','RLPGMV','FFH1','FFH2','FFH3','FFH4','FFH_FSP_1','FFH_FSP_2','BIOTOP','BioNr','BioCode','BioName','Para20','StandCode','BioTyp1','BioTyp2','BioTyp3','HLRT_WM','Massn_1','Massn_2','Massn_3','Instrument')

rl <- merge(taxdbf[,c("SPECIES_NR","LETTERCODE","ABBREVIAT","RANG", "GRUPPE")], traits[,select.rl], by.x='ABBREVIAT', by.y='Taxname')
rl <- rl[!apply(rl[,select.rl[4:length(select.rl)]], 1, function(x) all(is.na(x) | x == 0 | x == '')),]
write.csv2(rl, file='RL-MV.csv')


# 
# bfn <-'tv_refliste.sqlite'
# m <- dbDriver("SQLite")
# con <- dbConnect(m, dbname = bfn)
# dbListTables(con)
# ws <- dbGetQuery(con, "SELECT * FROM WasserstufenKoepke")
# ws <- ws[-1,]
# #paste(shQuote(names(ws)), collapse=",")
# GSL_name <- unlist(sapply(ws$TaxonName, function(x) tax(x, strict=TRUE, quiet=TRUE)$TaxonName))
# 
# ws$TaxonName[!ws$TaxonName %in% GSL_name]
# ws$SPECIES_NR <- tax(GSL_name, strict=TRUE, quiet=TRUE)$TaxonUsageID
# ws$LETTERCODE <- tax(GSL_name, strict=TRUE, quiet=TRUE)$LETTERCODE
# ws$TaxonName[which(duplicated(ws$LETTERCODE))]
# 
# table(ws$"4+")
# 
# # write.dbf(ws, file='wasserstufen.dbf')
# source('~/workspace/vegdata.dev/vegdata.dev/R/tv.write.r')
# cl <- c("integer", "character", "character", "numeric","numeric", "numeric","numeric","numeric","numeric", "numeric","numeric", "numeric","numeric", "numeric","numeric", "numeric","numeric", "numeric","numeric", "numeric","integer", "character", "integer", "character")
# dec <- c(0, 150, 7, 3,3, 3,3,3,3, 3,3, 3,3, 3,3, 3,3, 3,3, 3,4, 100, 0, 8)
# write.tvdbf(ws, file='wasserstufen.dbf', cl=cl, dec=dec)
# 
# dbDisconnect(con)
# 
#################################################

library(vegdata)
tv.compRefl('GermanSL 1.3', 'GermanSL 1.3.1')


